<?php
session_start();

if (isset($_POST['logout'])) {
  session_destroy();
  header("Location: login.php");
  exit;
}

// Validar que el usuario tenga rol permitido
if (!isset($_SESSION['rol']) || !in_array($_SESSION['rol'], ['usuario', 'admin'])) {
  header("Location: login.php");
  exit;
}

// Evitar que Alonso acceda aquí
if (strtolower($_SESSION['correo']) === 'alonso.reyes@grupoblmg.com') {
  header("Location: admin_home.php");
  exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>👋 Bienvenido Ejecutivo</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      text-align: center;
      padding-top: 100px;
    }
    h2 {
      color: #333;
      margin-bottom: 30px;
    }
    .opciones {
      display: flex;
      justify-content: center;
      gap: 40px;
      flex-wrap: wrap;
    }
    .opciones a {
      display: inline-block;
      background-color: #28a745;
      color: white;
      text-decoration: none;
      padding: 15px 25px;
      border-radius: 8px;
      font-size: 16px;
      transition: background-color 0.3s;
    }
    .opciones a:hover {
      background-color: #218838;
    }
    .logout {
      position: fixed;
      top: 20px;
      right: 20px;
    }
    .logout button {
      background: #ff4d4d;
      color: white;
      border: none;
      padding: 10px 16px;
      font-size: 14px;
      border-radius: 6px;
      cursor: pointer;
    }
    .logout button:hover {
      background-color: #cc0000;
    }
  </style>
</head>
<body>

  <form method="POST" class="logout">
    <button type="submit" name="logout">🔒 Cerrar sesión</button>
  </form>

  <h2>
    👋 Bienvenido, <?= htmlspecialchars($_SESSION['nombre']) ?>
  </h2>

  <div class="opciones">
    <a href="panel_visitas.php">📋 Panel Prospección</a>
    <a href="panel_recorrido.php">📍 Panel Recorrido</a>
  </div>

</body>
</html>