<?php
session_start();
if (!isset($_SESSION['rol'])) {
  header("Location: login.php");
  exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$busqueda = $_GET['buscar'] ?? '';
$kamFiltro = $_GET['kam'] ?? '';
$params = [];

if ($_SESSION['rol'] === 'usuario') {
  $sql = "SELECT * FROM visitas WHERE kam = ?";
  $params[] = $_SESSION['nombre'];
  if ($busqueda) {
    $sql .= " AND (ruc LIKE ? OR nombre_comercial LIKE ? OR producto LIKE ?)";
    $params[] = "%$busqueda%";
    $params[] = "%$busqueda%";
    $params[] = "%$busqueda%";
  }
} elseif ($_SESSION['rol'] === 'admin') {
  if ($_SESSION['correo'] === 'alonso.reyes@grupoblmg.com') {
    $sql = "SELECT * FROM visitas WHERE 1";
    if ($busqueda) {
      $sql .= " AND (ruc LIKE ? OR nombre_comercial LIKE ? OR producto LIKE ?)";
      $params[] = "%$busqueda%";
      $params[] = "%$busqueda%";
      $params[] = "%$busqueda%";
    }
    if ($kamFiltro) {
      $sql .= " AND kam = ?";
      $params[] = $kamFiltro;
    }
  } else {
    $sql = "
      SELECT v.* FROM visitas v
      JOIN usuarios u ON v.kam = u.nombre
      WHERE u.region = ?
    ";
    $params[] = $_SESSION['region'];
    if ($busqueda) {
      $sql .= " AND (v.ruc LIKE ? OR v.nombre_comercial LIKE ? OR v.producto LIKE ?)";
      $params[] = "%$busqueda%";
      $params[] = "%$busqueda%";
      $params[] = "%$busqueda%";
    }
  }
}

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$visitas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Cabeceras para descarga
header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename=visitas_exportadas.csv');

// UTF-8 BOM para compatibilidad con Excel
echo "\xEF\xBB\xBF";

$output = fopen('php://output', 'w');

// Encabezados con punto y coma
fputcsv($output, [
  'ID', 'Fecha', 'KAM', 'RUC', 'Nombre Comercial', 'Giro', 'Gestión',
  'Etapa', 'Tipificación', 'Producto', 'Valor Potencial', 'Mes Cierre', 'Comentario'
], ';');

// Datos con punto y coma y comillas
foreach ($visitas as $v) {
  fputcsv($output, [
    $v['id'],
    $v['fecha'],
    $v['kam'],
    $v['ruc'],
    $v['nombre_comercial'],
    $v['giro'],
    $v['gestion'],
    $v['etapa'],
    $v['tipificacion'],
    $v['producto'],
    $v['valor_potencial'],
    $v['mes_cierre'],
    $v['comentario']
  ], ';', '"');
}

fclose($output);
exit;