<?php
session_start();
if ($_SESSION['rol'] !== 'admin') {
  header("Location: login.php");
  exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=masterc2_crud_visitas;charset=utf8mb4", "masterc2_blmg", "@l0nzo30");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Indicadores
$totalVisitas = $pdo->query("SELECT COUNT(*) FROM visitas")->fetchColumn();
$totalValor = $pdo->query("SELECT SUM(valor_potencial) FROM visitas")->fetchColumn();
$porEtapa = $pdo->query("SELECT etapa, COUNT(*) as cantidad FROM visitas GROUP BY etapa")->fetchAll(PDO::FETCH_ASSOC);
$porKAM = $pdo->query("SELECT kam, COUNT(*) as cantidad FROM visitas GROUP BY kam")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>📊 Dashboard de Indicadores</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f4f4;
      padding: 20px;
      margin: 0;
    }
    h2 {
      color: #333;
      margin-bottom: 20px;
    }
    .indicadores {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
      margin-bottom: 30px;
    }
    .card-indicador {
      background: white;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 0 5px rgba(0,0,0,0.1);
      flex: 1;
      min-width: 220px;
    }
    .card-indicador h3 {
      margin: 0 0 10px;
      color: #007bff;
      font-size: 18px;
    }
    .card-indicador p {
      font-size: 24px;
      font-weight: bold;
      color: #333;
    }
    canvas {
      background: white;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 0 5px rgba(0,0,0,0.1);
    }
  </style>
</head>
<body>
  <h2>📊 Dashboard de Indicadores</h2>

  <div class="indicadores">
    <div class="card-indicador">
      <h3>Total de visitas</h3>
      <p><?= $totalVisitas ?></p>
    </div>
    <div class="card-indicador">
      <h3>Valor potencial total</h3>
      <p>S/ <?= number_format($totalValor, 0, '', ',') ?></p>
    </div>
  </div>

  <h3>📈 Visitas por etapa</h3>
  <canvas id="graficoEtapas" height="120"></canvas>

  <script>
    const ctx = document.getElementById('graficoEtapas').getContext('2d');
    const grafico = new Chart(ctx, {
      type: 'bar',
      data: {
        labels: <?= json_encode(array_column($porEtapa, 'etapa')) ?>,
        datasets: [{
          label: 'Cantidad de visitas',
          data: <?= json_encode(array_column($porEtapa, 'cantidad')) ?>,
          backgroundColor: '#007bff'
        }]
      },
      options: {
        responsive: true,
        plugins: {
          legend: { display: false },
          title: { display: false }
        },
        scales: {
          y: { beginAtZero: true }
        }
      }
    });
  </script>
</body>
</html>